<?php
/* --------------------------------------------------------------
 CommandDispatcherServiceProvider.php 2020-04-21
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Command;

use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Logging\LoggerBuilder;

/**
 * Class CommandDispatcherServiceProvider
 * @package Gambio\Core\Command
 */
class CommandDispatcherServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            Interfaces\CommandDispatcher::class,
            Interfaces\CommandHandlerProvider::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(Interfaces\CommandDispatcher::class,
            function () {
                /** @var LoggerBuilder $loggerBuilder */
                $loggerBuilder = $this->application->get(LoggerBuilder::class);
                $dispatcher    = new CommandDispatcher($loggerBuilder->changeNamespace('command_handlers')->build());
                $dispatcher->registerProvider($this->application->get(Interfaces\CommandHandlerProvider::class));
                
                return $dispatcher;
            });
        $this->application->share(Interfaces\CommandHandlerProvider::class, CommandHandlerProvider::class)
            ->addArgument($this->application);
    }
}